package zio.aws.appsync.model
import scala.jdk.CollectionConverters.*
sealed trait ConflictHandlerType {
  def unwrap: software.amazon.awssdk.services.appsync.model.ConflictHandlerType
}
object ConflictHandlerType {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.ConflictHandlerType
  ): zio.aws.appsync.model.ConflictHandlerType = value match {
    case software.amazon.awssdk.services.appsync.model.ConflictHandlerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.ConflictHandlerType.OPTIMISTIC_CONCURRENCY =>
      val r = OPTIMISTIC_CONCURRENCY
      r
    case software.amazon.awssdk.services.appsync.model.ConflictHandlerType.LAMBDA =>
      val r = LAMBDA
      r
    case software.amazon.awssdk.services.appsync.model.ConflictHandlerType.AUTOMERGE =>
      val r = AUTOMERGE
      r
    case software.amazon.awssdk.services.appsync.model.ConflictHandlerType.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appsync.model.ConflictHandlerType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ConflictHandlerType =
      software.amazon.awssdk.services.appsync.model.ConflictHandlerType.UNKNOWN_TO_SDK_VERSION
  }
  case object OPTIMISTIC_CONCURRENCY
      extends zio.aws.appsync.model.ConflictHandlerType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ConflictHandlerType =
      software.amazon.awssdk.services.appsync.model.ConflictHandlerType.OPTIMISTIC_CONCURRENCY
  }
  case object LAMBDA extends zio.aws.appsync.model.ConflictHandlerType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ConflictHandlerType =
      software.amazon.awssdk.services.appsync.model.ConflictHandlerType.LAMBDA
  }
  case object AUTOMERGE extends zio.aws.appsync.model.ConflictHandlerType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ConflictHandlerType =
      software.amazon.awssdk.services.appsync.model.ConflictHandlerType.AUTOMERGE
  }
  case object NONE extends zio.aws.appsync.model.ConflictHandlerType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ConflictHandlerType =
      software.amazon.awssdk.services.appsync.model.ConflictHandlerType.NONE
  }
}
