package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartSchemaMergeResponse(
    sourceApiAssociationStatus: Optional[
      zio.aws.appsync.model.SourceApiAssociationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.StartSchemaMergeResponse = {
    import StartSchemaMergeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.StartSchemaMergeResponse
      .builder()
      .optionallyWith(sourceApiAssociationStatus.map(value => value.unwrap))(
        _.sourceApiAssociationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.StartSchemaMergeResponse.ReadOnly =
    zio.aws.appsync.model.StartSchemaMergeResponse.wrap(buildAwsValue())
}
object StartSchemaMergeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.StartSchemaMergeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.StartSchemaMergeResponse =
      zio.aws.appsync.model.StartSchemaMergeResponse(
        sourceApiAssociationStatus.map(value => value)
      )
    def sourceApiAssociationStatus
        : Optional[zio.aws.appsync.model.SourceApiAssociationStatus]
    def getSourceApiAssociationStatus
        : ZIO[Any, AwsError, zio.aws.appsync.model.SourceApiAssociationStatus] =
      AwsError.unwrapOptionField(
        "sourceApiAssociationStatus",
        sourceApiAssociationStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.StartSchemaMergeResponse
  ) extends zio.aws.appsync.model.StartSchemaMergeResponse.ReadOnly {
    override val sourceApiAssociationStatus
        : Optional[zio.aws.appsync.model.SourceApiAssociationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociationStatus())
        .map(value =>
          zio.aws.appsync.model.SourceApiAssociationStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.StartSchemaMergeResponse
  ): zio.aws.appsync.model.StartSchemaMergeResponse.ReadOnly = new Wrapper(impl)
}
