package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateMergedGraphqlApiRequest(
    sourceApiIdentifier: String,
    mergedApiIdentifier: String,
    description: Optional[String] = Optional.Absent,
    sourceApiAssociationConfig: Optional[
      zio.aws.appsync.model.SourceApiAssociationConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiRequest = {
    import AssociateMergedGraphqlApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiRequest
      .builder()
      .sourceApiIdentifier(sourceApiIdentifier: java.lang.String)
      .mergedApiIdentifier(mergedApiIdentifier: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        sourceApiAssociationConfig.map(value => value.buildAwsValue())
      )(_.sourceApiAssociationConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.AssociateMergedGraphqlApiRequest.ReadOnly =
    zio.aws.appsync.model.AssociateMergedGraphqlApiRequest.wrap(buildAwsValue())
}
object AssociateMergedGraphqlApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.AssociateMergedGraphqlApiRequest =
      zio.aws.appsync.model.AssociateMergedGraphqlApiRequest(
        sourceApiIdentifier,
        mergedApiIdentifier,
        description.map(value => value),
        sourceApiAssociationConfig.map(value => value.asEditable)
      )
    def sourceApiIdentifier: String
    def mergedApiIdentifier: String
    def description: Optional[String]
    def sourceApiAssociationConfig
        : Optional[zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly]
    def getSourceApiIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceApiIdentifier)
    def getMergedApiIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(mergedApiIdentifier)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSourceApiAssociationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceApiAssociationConfig",
      sourceApiAssociationConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiRequest
  ) extends zio.aws.appsync.model.AssociateMergedGraphqlApiRequest.ReadOnly {
    override val sourceApiIdentifier: String =
      impl.sourceApiIdentifier(): String
    override val mergedApiIdentifier: String =
      impl.mergedApiIdentifier(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val sourceApiAssociationConfig
        : Optional[zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociationConfig())
        .map(value =>
          zio.aws.appsync.model.SourceApiAssociationConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiRequest
  ): zio.aws.appsync.model.AssociateMergedGraphqlApiRequest.ReadOnly =
    new Wrapper(impl)
}
