package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ErrorMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluateCodeErrorDetail(
    message: Optional[ErrorMessage] = Optional.Absent,
    codeErrors: Optional[Iterable[zio.aws.appsync.model.CodeError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.EvaluateCodeErrorDetail = {
    import EvaluateCodeErrorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.EvaluateCodeErrorDetail
      .builder()
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        codeErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.codeErrors)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.EvaluateCodeErrorDetail.ReadOnly =
    zio.aws.appsync.model.EvaluateCodeErrorDetail.wrap(buildAwsValue())
}
object EvaluateCodeErrorDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.EvaluateCodeErrorDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.EvaluateCodeErrorDetail =
      zio.aws.appsync.model.EvaluateCodeErrorDetail(
        message.map(value => value),
        codeErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def message: Optional[ErrorMessage]
    def codeErrors: Optional[List[zio.aws.appsync.model.CodeError.ReadOnly]]
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCodeErrors
        : ZIO[Any, AwsError, List[zio.aws.appsync.model.CodeError.ReadOnly]] =
      AwsError.unwrapOptionField("codeErrors", codeErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.EvaluateCodeErrorDetail
  ) extends zio.aws.appsync.model.EvaluateCodeErrorDetail.ReadOnly {
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.appsync.model.primitives.ErrorMessage(value))
    override val codeErrors
        : Optional[List[zio.aws.appsync.model.CodeError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appsync.model.CodeError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.EvaluateCodeErrorDetail
  ): zio.aws.appsync.model.EvaluateCodeErrorDetail.ReadOnly = new Wrapper(impl)
}
