package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateApiCacheResponse(
    apiCache: Optional[zio.aws.appsync.model.ApiCache] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse = {
    import UpdateApiCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse
      .builder()
      .optionallyWith(apiCache.map(value => value.buildAwsValue()))(_.apiCache)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly =
    zio.aws.appsync.model.UpdateApiCacheResponse.wrap(buildAwsValue())
}
object UpdateApiCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateApiCacheResponse =
      zio.aws.appsync.model
        .UpdateApiCacheResponse(apiCache.map(value => value.asEditable))
    def apiCache: Optional[zio.aws.appsync.model.ApiCache.ReadOnly]
    def getApiCache
        : ZIO[Any, AwsError, zio.aws.appsync.model.ApiCache.ReadOnly] =
      AwsError.unwrapOptionField("apiCache", apiCache)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse
  ) extends zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly {
    override val apiCache: Optional[zio.aws.appsync.model.ApiCache.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiCache())
        .map(value => zio.aws.appsync.model.ApiCache.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse
  ): zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly = new Wrapper(impl)
}
