package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDomainNameResponse(
    domainNameConfig: Optional[zio.aws.appsync.model.DomainNameConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetDomainNameResponse = {
    import GetDomainNameResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetDomainNameResponse
      .builder()
      .optionallyWith(domainNameConfig.map(value => value.buildAwsValue()))(
        _.domainNameConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetDomainNameResponse.ReadOnly =
    zio.aws.appsync.model.GetDomainNameResponse.wrap(buildAwsValue())
}
object GetDomainNameResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetDomainNameResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetDomainNameResponse =
      zio.aws.appsync.model
        .GetDomainNameResponse(domainNameConfig.map(value => value.asEditable))
    def domainNameConfig
        : Optional[zio.aws.appsync.model.DomainNameConfig.ReadOnly]
    def getDomainNameConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.DomainNameConfig.ReadOnly] =
      AwsError.unwrapOptionField("domainNameConfig", domainNameConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetDomainNameResponse
  ) extends zio.aws.appsync.model.GetDomainNameResponse.ReadOnly {
    override val domainNameConfig
        : Optional[zio.aws.appsync.model.DomainNameConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainNameConfig())
        .map(value => zio.aws.appsync.model.DomainNameConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetDomainNameResponse
  ): zio.aws.appsync.model.GetDomainNameResponse.ReadOnly = new Wrapper(impl)
}
