package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodeError(
    errorType: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    location: Optional[zio.aws.appsync.model.CodeErrorLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CodeError = {
    import CodeError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CodeError
      .builder()
      .optionallyWith(errorType.map(value => value: java.lang.String))(
        _.errorType
      )
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CodeError.ReadOnly =
    zio.aws.appsync.model.CodeError.wrap(buildAwsValue())
}
object CodeError {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appsync.model.CodeError] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CodeError =
      zio.aws.appsync.model.CodeError(
        errorType.map(value => value),
        value.map(value => value),
        location.map(value => value.asEditable)
      )
    def errorType: Optional[String]
    def value: Optional[String]
    def location: Optional[zio.aws.appsync.model.CodeErrorLocation.ReadOnly]
    def getErrorType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorType", errorType)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.appsync.model.CodeErrorLocation.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CodeError
  ) extends zio.aws.appsync.model.CodeError.ReadOnly {
    override val errorType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorType())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val location
        : Optional[zio.aws.appsync.model.CodeErrorLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.appsync.model.CodeErrorLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CodeError
  ): zio.aws.appsync.model.CodeError.ReadOnly = new Wrapper(impl)
}
