package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AppSyncRuntime(
    name: zio.aws.appsync.model.RuntimeName,
    runtimeVersion: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.AppSyncRuntime = {
    import AppSyncRuntime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.AppSyncRuntime
      .builder()
      .name(name.unwrap)
      .runtimeVersion(runtimeVersion: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.AppSyncRuntime.ReadOnly =
    zio.aws.appsync.model.AppSyncRuntime.wrap(buildAwsValue())
}
object AppSyncRuntime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.AppSyncRuntime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.AppSyncRuntime =
      zio.aws.appsync.model.AppSyncRuntime(name, runtimeVersion)
    def name: zio.aws.appsync.model.RuntimeName
    def runtimeVersion: String
    def getName: ZIO[Any, Nothing, zio.aws.appsync.model.RuntimeName] =
      ZIO.succeed(name)
    def getRuntimeVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(runtimeVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.AppSyncRuntime
  ) extends zio.aws.appsync.model.AppSyncRuntime.ReadOnly {
    override val name: zio.aws.appsync.model.RuntimeName =
      zio.aws.appsync.model.RuntimeName.wrap(impl.name())
    override val runtimeVersion: String = impl.runtimeVersion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.AppSyncRuntime
  ): zio.aws.appsync.model.AppSyncRuntime.ReadOnly = new Wrapper(impl)
}
