package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ErrorMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ErrorDetail(
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ErrorDetail = {
    import ErrorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ErrorDetail
      .builder()
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ErrorDetail.ReadOnly =
    zio.aws.appsync.model.ErrorDetail.wrap(buildAwsValue())
}
object ErrorDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ErrorDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ErrorDetail =
      zio.aws.appsync.model.ErrorDetail(message.map(value => value))
    def message: Optional[ErrorMessage]
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ErrorDetail
  ) extends zio.aws.appsync.model.ErrorDetail.ReadOnly {
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.appsync.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ErrorDetail
  ): zio.aws.appsync.model.ErrorDetail.ReadOnly = new Wrapper(impl)
}
