package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DynamodbDataSourceConfig(
    tableName: String,
    awsRegion: String,
    useCallerCredentials: Optional[Boolean] = Optional.Absent,
    deltaSyncConfig: Optional[zio.aws.appsync.model.DeltaSyncConfig] =
      Optional.Absent,
    versioned: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DynamodbDataSourceConfig = {
    import DynamodbDataSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DynamodbDataSourceConfig
      .builder()
      .tableName(tableName: java.lang.String)
      .awsRegion(awsRegion: java.lang.String)
      .optionallyWith(
        useCallerCredentials.map(value => value: java.lang.Boolean)
      )(_.useCallerCredentials)
      .optionallyWith(deltaSyncConfig.map(value => value.buildAwsValue()))(
        _.deltaSyncConfig
      )
      .optionallyWith(versioned.map(value => value: java.lang.Boolean))(
        _.versioned
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly =
    zio.aws.appsync.model.DynamodbDataSourceConfig.wrap(buildAwsValue())
}
object DynamodbDataSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DynamodbDataSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DynamodbDataSourceConfig =
      zio.aws.appsync.model.DynamodbDataSourceConfig(
        tableName,
        awsRegion,
        useCallerCredentials.map(value => value),
        deltaSyncConfig.map(value => value.asEditable),
        versioned.map(value => value)
      )
    def tableName: String
    def awsRegion: String
    def useCallerCredentials: Optional[Boolean]
    def deltaSyncConfig
        : Optional[zio.aws.appsync.model.DeltaSyncConfig.ReadOnly]
    def versioned: Optional[Boolean]
    def getTableName: ZIO[Any, Nothing, String] = ZIO.succeed(tableName)
    def getAwsRegion: ZIO[Any, Nothing, String] = ZIO.succeed(awsRegion)
    def getUseCallerCredentials: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useCallerCredentials", useCallerCredentials)
    def getDeltaSyncConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.DeltaSyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("deltaSyncConfig", deltaSyncConfig)
    def getVersioned: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("versioned", versioned)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DynamodbDataSourceConfig
  ) extends zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly {
    override val tableName: String = impl.tableName(): String
    override val awsRegion: String = impl.awsRegion(): String
    override val useCallerCredentials: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useCallerCredentials())
      .map(value => value: Boolean)
    override val deltaSyncConfig
        : Optional[zio.aws.appsync.model.DeltaSyncConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deltaSyncConfig())
        .map(value => zio.aws.appsync.model.DeltaSyncConfig.wrap(value))
    override val versioned: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.versioned())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DynamodbDataSourceConfig
  ): zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly = new Wrapper(impl)
}
