package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateApiKeyRequest(
    apiId: String,
    id: String,
    description: Optional[String] = Optional.Absent,
    expires: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest = {
    import UpdateApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .id(id: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(expires.map(value => value: java.lang.Long))(_.expires)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateApiKeyRequest.ReadOnly =
    zio.aws.appsync.model.UpdateApiKeyRequest.wrap(buildAwsValue())
}
object UpdateApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateApiKeyRequest =
      zio.aws.appsync.model.UpdateApiKeyRequest(
        apiId,
        id,
        description.map(value => value),
        expires.map(value => value)
      )
    def apiId: String
    def id: String
    def description: Optional[String]
    def expires: Optional[Long]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getExpires: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("expires", expires)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest
  ) extends zio.aws.appsync.model.UpdateApiKeyRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val id: String = impl.id(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val expires: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest
  ): zio.aws.appsync.model.UpdateApiKeyRequest.ReadOnly = new Wrapper(impl)
}
