package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.EvaluationResult
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluateMappingTemplateResponse(
    evaluationResult: Optional[EvaluationResult] = Optional.Absent,
    error: Optional[zio.aws.appsync.model.ErrorDetail] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateResponse = {
    import EvaluateMappingTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateResponse
      .builder()
      .optionallyWith(
        evaluationResult.map(value =>
          EvaluationResult.unwrap(value): java.lang.String
        )
      )(_.evaluationResult)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.EvaluateMappingTemplateResponse.ReadOnly =
    zio.aws.appsync.model.EvaluateMappingTemplateResponse.wrap(buildAwsValue())
}
object EvaluateMappingTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.EvaluateMappingTemplateResponse =
      zio.aws.appsync.model.EvaluateMappingTemplateResponse(
        evaluationResult.map(value => value),
        error.map(value => value.asEditable)
      )
    def evaluationResult: Optional[EvaluationResult]
    def error: Optional[zio.aws.appsync.model.ErrorDetail.ReadOnly]
    def getEvaluationResult: ZIO[Any, AwsError, EvaluationResult] =
      AwsError.unwrapOptionField("evaluationResult", evaluationResult)
    def getError
        : ZIO[Any, AwsError, zio.aws.appsync.model.ErrorDetail.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateResponse
  ) extends zio.aws.appsync.model.EvaluateMappingTemplateResponse.ReadOnly {
    override val evaluationResult: Optional[EvaluationResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationResult())
        .map(value => zio.aws.appsync.model.primitives.EvaluationResult(value))
    override val error: Optional[zio.aws.appsync.model.ErrorDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.appsync.model.ErrorDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateResponse
  ): zio.aws.appsync.model.EvaluateMappingTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
