package zio.aws.appsync.model
import scala.jdk.CollectionConverters.*
sealed trait AssociationStatus {
  def unwrap: software.amazon.awssdk.services.appsync.model.AssociationStatus
}
object AssociationStatus {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.AssociationStatus
  ): zio.aws.appsync.model.AssociationStatus = value match {
    case software.amazon.awssdk.services.appsync.model.AssociationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.AssociationStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.appsync.model.AssociationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.appsync.model.AssociationStatus.SUCCESS =>
      val r = SUCCESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appsync.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AssociationStatus =
      software.amazon.awssdk.services.appsync.model.AssociationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PROCESSING extends zio.aws.appsync.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AssociationStatus =
      software.amazon.awssdk.services.appsync.model.AssociationStatus.PROCESSING
  }
  case object FAILED extends zio.aws.appsync.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AssociationStatus =
      software.amazon.awssdk.services.appsync.model.AssociationStatus.FAILED
  }
  case object SUCCESS extends zio.aws.appsync.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AssociationStatus =
      software.amazon.awssdk.services.appsync.model.AssociationStatus.SUCCESS
  }
}
