package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartSchemaCreationResponse(
    status: Optional[zio.aws.appsync.model.SchemaStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse = {
    import StartSchemaCreationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.StartSchemaCreationResponse.ReadOnly =
    zio.aws.appsync.model.StartSchemaCreationResponse.wrap(buildAwsValue())
}
object StartSchemaCreationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.StartSchemaCreationResponse =
      zio.aws.appsync.model
        .StartSchemaCreationResponse(status.map(value => value))
    def status: Optional[zio.aws.appsync.model.SchemaStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.appsync.model.SchemaStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse
  ) extends zio.aws.appsync.model.StartSchemaCreationResponse.ReadOnly {
    override val status: Optional[zio.aws.appsync.model.SchemaStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.appsync.model.SchemaStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse
  ): zio.aws.appsync.model.StartSchemaCreationResponse.ReadOnly = new Wrapper(
    impl
  )
}
