package zio.aws.appsync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appsync.model.primitives.{MaxResults, PaginationToken}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDomainNamesRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest = {
    import ListDomainNamesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListDomainNamesRequest.ReadOnly =
    zio.aws.appsync.model.ListDomainNamesRequest.wrap(buildAwsValue())
}
object ListDomainNamesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListDomainNamesRequest =
      zio.aws.appsync.model.ListDomainNamesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest
  ) extends zio.aws.appsync.model.ListDomainNamesRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appsync.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest
  ): zio.aws.appsync.model.ListDomainNamesRequest.ReadOnly = new Wrapper(impl)
}
