package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateApiKeyResponse(
    apiKey: Optional[zio.aws.appsync.model.ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse = {
    import UpdateApiKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse
      .builder()
      .optionallyWith(apiKey.map(value => value.buildAwsValue()))(_.apiKey)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateApiKeyResponse.ReadOnly =
    zio.aws.appsync.model.UpdateApiKeyResponse.wrap(buildAwsValue())
}
object UpdateApiKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateApiKeyResponse =
      zio.aws.appsync.model
        .UpdateApiKeyResponse(apiKey.map(value => value.asEditable))
    def apiKey: Optional[zio.aws.appsync.model.ApiKey.ReadOnly]
    def getApiKey: ZIO[Any, AwsError, zio.aws.appsync.model.ApiKey.ReadOnly] =
      AwsError.unwrapOptionField("apiKey", apiKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse
  ) extends zio.aws.appsync.model.UpdateApiKeyResponse.ReadOnly {
    override val apiKey: Optional[zio.aws.appsync.model.ApiKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKey())
        .map(value => zio.aws.appsync.model.ApiKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse
  ): zio.aws.appsync.model.UpdateApiKeyResponse.ReadOnly = new Wrapper(impl)
}
