package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HttpDataSourceConfig(
    endpoint: Optional[String] = Optional.Absent,
    authorizationConfig: Optional[zio.aws.appsync.model.AuthorizationConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig = {
    import HttpDataSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig
      .builder()
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(authorizationConfig.map(value => value.buildAwsValue()))(
        _.authorizationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly =
    zio.aws.appsync.model.HttpDataSourceConfig.wrap(buildAwsValue())
}
object HttpDataSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.HttpDataSourceConfig =
      zio.aws.appsync.model.HttpDataSourceConfig(
        endpoint.map(value => value),
        authorizationConfig.map(value => value.asEditable)
      )
    def endpoint: Optional[String]
    def authorizationConfig
        : Optional[zio.aws.appsync.model.AuthorizationConfig.ReadOnly]
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getAuthorizationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.AuthorizationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("authorizationConfig", authorizationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig
  ) extends zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly {
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val authorizationConfig
        : Optional[zio.aws.appsync.model.AuthorizationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizationConfig())
        .map(value => zio.aws.appsync.model.AuthorizationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig
  ): zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly = new Wrapper(impl)
}
