package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.BooleanValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetIntrospectionSchemaRequest(
    apiId: String,
    format: zio.aws.appsync.model.OutputType,
    includeDirectives: Optional[BooleanValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest = {
    import GetIntrospectionSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .format(format.unwrap)
      .optionallyWith(includeDirectives.map(value => value: java.lang.Boolean))(
        _.includeDirectives
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetIntrospectionSchemaRequest.ReadOnly =
    zio.aws.appsync.model.GetIntrospectionSchemaRequest.wrap(buildAwsValue())
}
object GetIntrospectionSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetIntrospectionSchemaRequest =
      zio.aws.appsync.model.GetIntrospectionSchemaRequest(
        apiId,
        format,
        includeDirectives.map(value => value)
      )
    def apiId: String
    def format: zio.aws.appsync.model.OutputType
    def includeDirectives: Optional[BooleanValue]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getFormat: ZIO[Any, Nothing, zio.aws.appsync.model.OutputType] =
      ZIO.succeed(format)
    def getIncludeDirectives: ZIO[Any, AwsError, BooleanValue] =
      AwsError.unwrapOptionField("includeDirectives", includeDirectives)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest
  ) extends zio.aws.appsync.model.GetIntrospectionSchemaRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val format: zio.aws.appsync.model.OutputType =
      zio.aws.appsync.model.OutputType.wrap(impl.format())
    override val includeDirectives: Optional[BooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeDirectives())
        .map(value => value: BooleanValue)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest
  ): zio.aws.appsync.model.GetIntrospectionSchemaRequest.ReadOnly = new Wrapper(
    impl
  )
}
