package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateApiCacheRequest(
    apiId: String,
    ttl: Long,
    transitEncryptionEnabled: Optional[Boolean] = Optional.Absent,
    atRestEncryptionEnabled: Optional[Boolean] = Optional.Absent,
    apiCachingBehavior: zio.aws.appsync.model.ApiCachingBehavior,
    `type`: zio.aws.appsync.model.ApiCacheType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest = {
    import CreateApiCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .ttl(ttl: java.lang.Long)
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .apiCachingBehavior(apiCachingBehavior.unwrap)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateApiCacheRequest.ReadOnly =
    zio.aws.appsync.model.CreateApiCacheRequest.wrap(buildAwsValue())
}
object CreateApiCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateApiCacheRequest =
      zio.aws.appsync.model.CreateApiCacheRequest(
        apiId,
        ttl,
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        apiCachingBehavior,
        `type`
      )
    def apiId: String
    def ttl: Long
    def transitEncryptionEnabled: Optional[Boolean]
    def atRestEncryptionEnabled: Optional[Boolean]
    def apiCachingBehavior: zio.aws.appsync.model.ApiCachingBehavior
    def `type`: zio.aws.appsync.model.ApiCacheType
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getTtl: ZIO[Any, Nothing, Long] = ZIO.succeed(ttl)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("transitEncryptionEnabled", transitEncryptionEnabled)
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("atRestEncryptionEnabled", atRestEncryptionEnabled)
    def getApiCachingBehavior
        : ZIO[Any, Nothing, zio.aws.appsync.model.ApiCachingBehavior] =
      ZIO.succeed(apiCachingBehavior)
    def getType: ZIO[Any, Nothing, zio.aws.appsync.model.ApiCacheType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest
  ) extends zio.aws.appsync.model.CreateApiCacheRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val ttl: Long = impl.ttl(): Long
    override val transitEncryptionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionEnabled())
        .map(value => value: Boolean)
    override val atRestEncryptionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.atRestEncryptionEnabled())
        .map(value => value: Boolean)
    override val apiCachingBehavior: zio.aws.appsync.model.ApiCachingBehavior =
      zio.aws.appsync.model.ApiCachingBehavior.wrap(impl.apiCachingBehavior())
    override val `type`: zio.aws.appsync.model.ApiCacheType =
      zio.aws.appsync.model.ApiCacheType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest
  ): zio.aws.appsync.model.CreateApiCacheRequest.ReadOnly = new Wrapper(impl)
}
