package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateGraphqlApiResponse(
    graphqlApi: Optional[zio.aws.appsync.model.GraphqlApi] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse = {
    import CreateGraphqlApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse
      .builder()
      .optionallyWith(graphqlApi.map(value => value.buildAwsValue()))(
        _.graphqlApi
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly =
    zio.aws.appsync.model.CreateGraphqlApiResponse.wrap(buildAwsValue())
}
object CreateGraphqlApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateGraphqlApiResponse =
      zio.aws.appsync.model
        .CreateGraphqlApiResponse(graphqlApi.map(value => value.asEditable))
    def graphqlApi: Optional[zio.aws.appsync.model.GraphqlApi.ReadOnly]
    def getGraphqlApi
        : ZIO[Any, AwsError, zio.aws.appsync.model.GraphqlApi.ReadOnly] =
      AwsError.unwrapOptionField("graphqlApi", graphqlApi)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse
  ) extends zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly {
    override val graphqlApi
        : Optional[zio.aws.appsync.model.GraphqlApi.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.graphqlApi())
        .map(value => zio.aws.appsync.model.GraphqlApi.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse
  ): zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly = new Wrapper(impl)
}
