package zio.aws.appsync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appsync.model.primitives.{MaxResults, PaginationToken}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListResolversByFunctionRequest(
    apiId: String,
    functionId: String,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest = {
    import ListResolversByFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .functionId(functionId: java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.ListResolversByFunctionRequest.ReadOnly =
    zio.aws.appsync.model.ListResolversByFunctionRequest.wrap(buildAwsValue())
}
object ListResolversByFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListResolversByFunctionRequest =
      zio.aws.appsync.model.ListResolversByFunctionRequest(
        apiId,
        functionId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def apiId: String
    def functionId: String
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getFunctionId: ZIO[Any, Nothing, String] = ZIO.succeed(functionId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest
  ) extends zio.aws.appsync.model.ListResolversByFunctionRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val functionId: String = impl.functionId(): String
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appsync.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest
  ): zio.aws.appsync.model.ListResolversByFunctionRequest.ReadOnly =
    new Wrapper(impl)
}
