package zio.aws.appsync
import zio.aws.appsync.model.CreateDomainNameResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.appsync.model.{
  UpdateResolverRequest,
  UpdateTypeRequest,
  DisassociateApiRequest,
  DeleteApiKeyRequest,
  AssociateApiRequest,
  DeleteTypeRequest,
  CreateGraphqlApiRequest,
  CreateApiKeyRequest,
  UpdateDataSourceRequest,
  GetGraphqlApiRequest,
  GetFunctionRequest,
  DeleteGraphqlApiRequest,
  DeleteApiCacheRequest,
  DeleteFunctionRequest,
  ListGraphqlApisRequest,
  GetTypeRequest,
  GetResolverRequest,
  ListTagsForResourceRequest,
  FlushApiCacheRequest,
  CreateDataSourceRequest,
  GetApiCacheRequest,
  CreateTypeRequest,
  ListResolversByFunctionRequest,
  ListTypesRequest,
  GetDataSourceRequest,
  ListDomainNamesRequest,
  GetApiAssociationRequest,
  CreateResolverRequest,
  StartSchemaCreationRequest,
  UpdateApiCacheRequest,
  DeleteDomainNameRequest,
  UpdateDomainNameRequest,
  CreateDomainNameRequest,
  ListDataSourcesRequest,
  CreateFunctionRequest,
  DeleteDataSourceRequest,
  ListFunctionsRequest,
  UntagResourceRequest,
  GetIntrospectionSchemaRequest,
  CreateApiCacheRequest,
  GetSchemaCreationStatusRequest,
  UpdateFunctionRequest,
  ListResolversRequest,
  GetDomainNameRequest,
  ListApiKeysRequest,
  DeleteResolverRequest,
  UpdateGraphqlApiRequest,
  TagResourceRequest,
  UpdateApiKeyRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient
object AppSyncMock extends Mock[AppSync] {
  object ListTypes
      extends Effect[
        ListTypesRequest,
        AwsError,
        zio.aws.appsync.model.ListTypesResponse.ReadOnly
      ]
  object UpdateType
      extends Effect[
        UpdateTypeRequest,
        AwsError,
        zio.aws.appsync.model.UpdateTypeResponse.ReadOnly
      ]
  object GetDataSource
      extends Effect[
        GetDataSourceRequest,
        AwsError,
        zio.aws.appsync.model.GetDataSourceResponse.ReadOnly
      ]
  object GetApiCache
      extends Effect[
        GetApiCacheRequest,
        AwsError,
        zio.aws.appsync.model.GetApiCacheResponse.ReadOnly
      ]
  object CreateApiCache
      extends Effect[
        CreateApiCacheRequest,
        AwsError,
        zio.aws.appsync.model.CreateApiCacheResponse.ReadOnly
      ]
  object UpdateApiKey
      extends Effect[
        UpdateApiKeyRequest,
        AwsError,
        zio.aws.appsync.model.UpdateApiKeyResponse.ReadOnly
      ]
  object GetIntrospectionSchema
      extends Effect[
        GetIntrospectionSchemaRequest,
        AwsError,
        zio.aws.appsync.model.GetIntrospectionSchemaResponse.ReadOnly
      ]
  object FlushApiCache
      extends Effect[
        FlushApiCacheRequest,
        AwsError,
        zio.aws.appsync.model.FlushApiCacheResponse.ReadOnly
      ]
  object UpdateApiCache
      extends Effect[
        UpdateApiCacheRequest,
        AwsError,
        zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly
      ]
  object CreateDataSource
      extends Effect[
        CreateDataSourceRequest,
        AwsError,
        zio.aws.appsync.model.CreateDataSourceResponse.ReadOnly
      ]
  object DisassociateApi
      extends Effect[
        DisassociateApiRequest,
        AwsError,
        zio.aws.appsync.model.DisassociateApiResponse.ReadOnly
      ]
  object DeleteApiCache
      extends Effect[
        DeleteApiCacheRequest,
        AwsError,
        zio.aws.appsync.model.DeleteApiCacheResponse.ReadOnly
      ]
  object DeleteFunction
      extends Effect[
        DeleteFunctionRequest,
        AwsError,
        zio.aws.appsync.model.DeleteFunctionResponse.ReadOnly
      ]
  object ListDataSources
      extends Effect[
        ListDataSourcesRequest,
        AwsError,
        zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly
      ]
  object CreateDomainName
      extends Effect[CreateDomainNameRequest, AwsError, ReadOnly]
  object CreateGraphqlApi
      extends Effect[
        CreateGraphqlApiRequest,
        AwsError,
        zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly
      ]
  object GetType
      extends Effect[
        GetTypeRequest,
        AwsError,
        zio.aws.appsync.model.GetTypeResponse.ReadOnly
      ]
  object GetResolver
      extends Effect[
        GetResolverRequest,
        AwsError,
        zio.aws.appsync.model.GetResolverResponse.ReadOnly
      ]
  object GetSchemaCreationStatus
      extends Effect[
        GetSchemaCreationStatusRequest,
        AwsError,
        zio.aws.appsync.model.GetSchemaCreationStatusResponse.ReadOnly
      ]
  object UpdateGraphqlApi
      extends Effect[
        UpdateGraphqlApiRequest,
        AwsError,
        zio.aws.appsync.model.UpdateGraphqlApiResponse.ReadOnly
      ]
  object CreateType
      extends Effect[
        CreateTypeRequest,
        AwsError,
        zio.aws.appsync.model.CreateTypeResponse.ReadOnly
      ]
  object ListResolvers
      extends Effect[
        ListResolversRequest,
        AwsError,
        zio.aws.appsync.model.ListResolversResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.appsync.model.UntagResourceResponse.ReadOnly
      ]
  object ListGraphqlApis
      extends Effect[
        ListGraphqlApisRequest,
        AwsError,
        zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly
      ]
  object UpdateDataSource
      extends Effect[
        UpdateDataSourceRequest,
        AwsError,
        zio.aws.appsync.model.UpdateDataSourceResponse.ReadOnly
      ]
  object DeleteApiKey
      extends Effect[
        DeleteApiKeyRequest,
        AwsError,
        zio.aws.appsync.model.DeleteApiKeyResponse.ReadOnly
      ]
  object UpdateResolver
      extends Effect[
        UpdateResolverRequest,
        AwsError,
        zio.aws.appsync.model.UpdateResolverResponse.ReadOnly
      ]
  object CreateApiKey
      extends Effect[
        CreateApiKeyRequest,
        AwsError,
        zio.aws.appsync.model.CreateApiKeyResponse.ReadOnly
      ]
  object UpdateFunction
      extends Effect[
        UpdateFunctionRequest,
        AwsError,
        zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly
      ]
  object DeleteDataSource
      extends Effect[
        DeleteDataSourceRequest,
        AwsError,
        zio.aws.appsync.model.DeleteDataSourceResponse.ReadOnly
      ]
  object ListApiKeys
      extends Effect[
        ListApiKeysRequest,
        AwsError,
        zio.aws.appsync.model.ListApiKeysResponse.ReadOnly
      ]
  object DeleteResolver
      extends Effect[
        DeleteResolverRequest,
        AwsError,
        zio.aws.appsync.model.DeleteResolverResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.appsync.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteGraphqlApi
      extends Effect[
        DeleteGraphqlApiRequest,
        AwsError,
        zio.aws.appsync.model.DeleteGraphqlApiResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.appsync.model.TagResourceResponse.ReadOnly
      ]
  object ListFunctions
      extends Effect[
        ListFunctionsRequest,
        AwsError,
        zio.aws.appsync.model.ListFunctionsResponse.ReadOnly
      ]
  object StartSchemaCreation
      extends Effect[
        StartSchemaCreationRequest,
        AwsError,
        zio.aws.appsync.model.StartSchemaCreationResponse.ReadOnly
      ]
  object AssociateApi
      extends Effect[
        AssociateApiRequest,
        AwsError,
        zio.aws.appsync.model.AssociateApiResponse.ReadOnly
      ]
  object CreateResolver
      extends Effect[
        CreateResolverRequest,
        AwsError,
        zio.aws.appsync.model.CreateResolverResponse.ReadOnly
      ]
  object DeleteType
      extends Effect[
        DeleteTypeRequest,
        AwsError,
        zio.aws.appsync.model.DeleteTypeResponse.ReadOnly
      ]
  object ListDomainNames
      extends Effect[
        ListDomainNamesRequest,
        AwsError,
        zio.aws.appsync.model.ListDomainNamesResponse.ReadOnly
      ]
  object GetGraphqlApi
      extends Effect[
        GetGraphqlApiRequest,
        AwsError,
        zio.aws.appsync.model.GetGraphqlApiResponse.ReadOnly
      ]
  object GetApiAssociation
      extends Effect[
        GetApiAssociationRequest,
        AwsError,
        zio.aws.appsync.model.GetApiAssociationResponse.ReadOnly
      ]
  object CreateFunction
      extends Effect[
        CreateFunctionRequest,
        AwsError,
        zio.aws.appsync.model.CreateFunctionResponse.ReadOnly
      ]
  object GetDomainName
      extends Effect[
        GetDomainNameRequest,
        AwsError,
        zio.aws.appsync.model.GetDomainNameResponse.ReadOnly
      ]
  object DeleteDomainName
      extends Effect[
        DeleteDomainNameRequest,
        AwsError,
        zio.aws.appsync.model.DeleteDomainNameResponse.ReadOnly
      ]
  object GetFunction
      extends Effect[
        GetFunctionRequest,
        AwsError,
        zio.aws.appsync.model.GetFunctionResponse.ReadOnly
      ]
  object UpdateDomainName
      extends Effect[
        UpdateDomainNameRequest,
        AwsError,
        zio.aws.appsync.model.UpdateDomainNameResponse.ReadOnly
      ]
  object ListResolversByFunction
      extends Effect[
        ListResolversByFunctionRequest,
        AwsError,
        zio.aws.appsync.model.ListResolversByFunctionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AppSync] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new AppSync {
          val api: AppSyncAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : AppSync = this
          def listTypes(
              request: ListTypesRequest
          ): IO[AwsError, zio.aws.appsync.model.ListTypesResponse.ReadOnly] =
            proxy(ListTypes, request)
          def updateType(
              request: UpdateTypeRequest
          ): IO[AwsError, zio.aws.appsync.model.UpdateTypeResponse.ReadOnly] =
            proxy(UpdateType, request)
          def getDataSource(request: GetDataSourceRequest): IO[
            AwsError,
            zio.aws.appsync.model.GetDataSourceResponse.ReadOnly
          ] = proxy(GetDataSource, request)
          def getApiCache(
              request: GetApiCacheRequest
          ): IO[AwsError, zio.aws.appsync.model.GetApiCacheResponse.ReadOnly] =
            proxy(GetApiCache, request)
          def createApiCache(request: CreateApiCacheRequest): IO[
            AwsError,
            zio.aws.appsync.model.CreateApiCacheResponse.ReadOnly
          ] = proxy(CreateApiCache, request)
          def updateApiKey(
              request: UpdateApiKeyRequest
          ): IO[AwsError, zio.aws.appsync.model.UpdateApiKeyResponse.ReadOnly] =
            proxy(UpdateApiKey, request)
          def getIntrospectionSchema(
              request: GetIntrospectionSchemaRequest
          ): IO[
            AwsError,
            zio.aws.appsync.model.GetIntrospectionSchemaResponse.ReadOnly
          ] = proxy(GetIntrospectionSchema, request)
          def flushApiCache(request: FlushApiCacheRequest): IO[
            AwsError,
            zio.aws.appsync.model.FlushApiCacheResponse.ReadOnly
          ] = proxy(FlushApiCache, request)
          def updateApiCache(request: UpdateApiCacheRequest): IO[
            AwsError,
            zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly
          ] = proxy(UpdateApiCache, request)
          def createDataSource(request: CreateDataSourceRequest): IO[
            AwsError,
            zio.aws.appsync.model.CreateDataSourceResponse.ReadOnly
          ] = proxy(CreateDataSource, request)
          def disassociateApi(request: DisassociateApiRequest): IO[
            AwsError,
            zio.aws.appsync.model.DisassociateApiResponse.ReadOnly
          ] = proxy(DisassociateApi, request)
          def deleteApiCache(request: DeleteApiCacheRequest): IO[
            AwsError,
            zio.aws.appsync.model.DeleteApiCacheResponse.ReadOnly
          ] = proxy(DeleteApiCache, request)
          def deleteFunction(request: DeleteFunctionRequest): IO[
            AwsError,
            zio.aws.appsync.model.DeleteFunctionResponse.ReadOnly
          ] = proxy(DeleteFunction, request)
          def listDataSources(request: ListDataSourcesRequest): IO[
            AwsError,
            zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly
          ] = proxy(ListDataSources, request)
          def createDomainName(
              request: CreateDomainNameRequest
          ): IO[AwsError, ReadOnly] = proxy(CreateDomainName, request)
          def createGraphqlApi(request: CreateGraphqlApiRequest): IO[
            AwsError,
            zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly
          ] = proxy(CreateGraphqlApi, request)
          def getType(
              request: GetTypeRequest
          ): IO[AwsError, zio.aws.appsync.model.GetTypeResponse.ReadOnly] =
            proxy(GetType, request)
          def getResolver(
              request: GetResolverRequest
          ): IO[AwsError, zio.aws.appsync.model.GetResolverResponse.ReadOnly] =
            proxy(GetResolver, request)
          def getSchemaCreationStatus(
              request: GetSchemaCreationStatusRequest
          ): IO[
            AwsError,
            zio.aws.appsync.model.GetSchemaCreationStatusResponse.ReadOnly
          ] = proxy(GetSchemaCreationStatus, request)
          def updateGraphqlApi(request: UpdateGraphqlApiRequest): IO[
            AwsError,
            zio.aws.appsync.model.UpdateGraphqlApiResponse.ReadOnly
          ] = proxy(UpdateGraphqlApi, request)
          def createType(
              request: CreateTypeRequest
          ): IO[AwsError, zio.aws.appsync.model.CreateTypeResponse.ReadOnly] =
            proxy(CreateType, request)
          def listResolvers(request: ListResolversRequest): IO[
            AwsError,
            zio.aws.appsync.model.ListResolversResponse.ReadOnly
          ] = proxy(ListResolvers, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.appsync.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def listGraphqlApis(request: ListGraphqlApisRequest): IO[
            AwsError,
            zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly
          ] = proxy(ListGraphqlApis, request)
          def updateDataSource(request: UpdateDataSourceRequest): IO[
            AwsError,
            zio.aws.appsync.model.UpdateDataSourceResponse.ReadOnly
          ] = proxy(UpdateDataSource, request)
          def deleteApiKey(
              request: DeleteApiKeyRequest
          ): IO[AwsError, zio.aws.appsync.model.DeleteApiKeyResponse.ReadOnly] =
            proxy(DeleteApiKey, request)
          def updateResolver(request: UpdateResolverRequest): IO[
            AwsError,
            zio.aws.appsync.model.UpdateResolverResponse.ReadOnly
          ] = proxy(UpdateResolver, request)
          def createApiKey(
              request: CreateApiKeyRequest
          ): IO[AwsError, zio.aws.appsync.model.CreateApiKeyResponse.ReadOnly] =
            proxy(CreateApiKey, request)
          def updateFunction(request: UpdateFunctionRequest): IO[
            AwsError,
            zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly
          ] = proxy(UpdateFunction, request)
          def deleteDataSource(request: DeleteDataSourceRequest): IO[
            AwsError,
            zio.aws.appsync.model.DeleteDataSourceResponse.ReadOnly
          ] = proxy(DeleteDataSource, request)
          def listApiKeys(
              request: ListApiKeysRequest
          ): IO[AwsError, zio.aws.appsync.model.ListApiKeysResponse.ReadOnly] =
            proxy(ListApiKeys, request)
          def deleteResolver(request: DeleteResolverRequest): IO[
            AwsError,
            zio.aws.appsync.model.DeleteResolverResponse.ReadOnly
          ] = proxy(DeleteResolver, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.appsync.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def deleteGraphqlApi(request: DeleteGraphqlApiRequest): IO[
            AwsError,
            zio.aws.appsync.model.DeleteGraphqlApiResponse.ReadOnly
          ] = proxy(DeleteGraphqlApi, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.appsync.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def listFunctions(request: ListFunctionsRequest): IO[
            AwsError,
            zio.aws.appsync.model.ListFunctionsResponse.ReadOnly
          ] = proxy(ListFunctions, request)
          def startSchemaCreation(request: StartSchemaCreationRequest): IO[
            AwsError,
            zio.aws.appsync.model.StartSchemaCreationResponse.ReadOnly
          ] = proxy(StartSchemaCreation, request)
          def associateApi(
              request: AssociateApiRequest
          ): IO[AwsError, zio.aws.appsync.model.AssociateApiResponse.ReadOnly] =
            proxy(AssociateApi, request)
          def createResolver(request: CreateResolverRequest): IO[
            AwsError,
            zio.aws.appsync.model.CreateResolverResponse.ReadOnly
          ] = proxy(CreateResolver, request)
          def deleteType(
              request: DeleteTypeRequest
          ): IO[AwsError, zio.aws.appsync.model.DeleteTypeResponse.ReadOnly] =
            proxy(DeleteType, request)
          def listDomainNames(request: ListDomainNamesRequest): IO[
            AwsError,
            zio.aws.appsync.model.ListDomainNamesResponse.ReadOnly
          ] = proxy(ListDomainNames, request)
          def getGraphqlApi(request: GetGraphqlApiRequest): IO[
            AwsError,
            zio.aws.appsync.model.GetGraphqlApiResponse.ReadOnly
          ] = proxy(GetGraphqlApi, request)
          def getApiAssociation(request: GetApiAssociationRequest): IO[
            AwsError,
            zio.aws.appsync.model.GetApiAssociationResponse.ReadOnly
          ] = proxy(GetApiAssociation, request)
          def createFunction(request: CreateFunctionRequest): IO[
            AwsError,
            zio.aws.appsync.model.CreateFunctionResponse.ReadOnly
          ] = proxy(CreateFunction, request)
          def getDomainName(request: GetDomainNameRequest): IO[
            AwsError,
            zio.aws.appsync.model.GetDomainNameResponse.ReadOnly
          ] = proxy(GetDomainName, request)
          def deleteDomainName(request: DeleteDomainNameRequest): IO[
            AwsError,
            zio.aws.appsync.model.DeleteDomainNameResponse.ReadOnly
          ] = proxy(DeleteDomainName, request)
          def getFunction(
              request: GetFunctionRequest
          ): IO[AwsError, zio.aws.appsync.model.GetFunctionResponse.ReadOnly] =
            proxy(GetFunction, request)
          def updateDomainName(request: UpdateDomainNameRequest): IO[
            AwsError,
            zio.aws.appsync.model.UpdateDomainNameResponse.ReadOnly
          ] = proxy(UpdateDomainName, request)
          def listResolversByFunction(
              request: ListResolversByFunctionRequest
          ): IO[
            AwsError,
            zio.aws.appsync.model.ListResolversByFunctionResponse.ReadOnly
          ] = proxy(ListResolversByFunction, request)
        }
      }
    }
  }
}
