package zio.aws.appsync.model
import scala.jdk.CollectionConverters.*
sealed trait ConflictDetectionType {
  def unwrap
      : software.amazon.awssdk.services.appsync.model.ConflictDetectionType
}
object ConflictDetectionType {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.ConflictDetectionType
  ): zio.aws.appsync.model.ConflictDetectionType = value match {
    case software.amazon.awssdk.services.appsync.model.ConflictDetectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.ConflictDetectionType.VERSION =>
      val r = VERSION
      r
    case software.amazon.awssdk.services.appsync.model.ConflictDetectionType.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appsync.model.ConflictDetectionType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ConflictDetectionType =
      software.amazon.awssdk.services.appsync.model.ConflictDetectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object VERSION extends zio.aws.appsync.model.ConflictDetectionType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ConflictDetectionType =
      software.amazon.awssdk.services.appsync.model.ConflictDetectionType.VERSION
  }
  case object NONE extends zio.aws.appsync.model.ConflictDetectionType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ConflictDetectionType =
      software.amazon.awssdk.services.appsync.model.ConflictDetectionType.NONE
  }
}
