package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDataSourceRequest(apiId: String, name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetDataSourceRequest = {
    import GetDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetDataSourceRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetDataSourceRequest.ReadOnly =
    zio.aws.appsync.model.GetDataSourceRequest.wrap(buildAwsValue())
}
object GetDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetDataSourceRequest =
      zio.aws.appsync.model.GetDataSourceRequest(apiId, name)
    def apiId: String
    def name: ResourceName
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetDataSourceRequest
  ) extends zio.aws.appsync.model.GetDataSourceRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val name: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetDataSourceRequest
  ): zio.aws.appsync.model.GetDataSourceRequest.ReadOnly = new Wrapper(impl)
}
