package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{
  CertificateArn,
  Description,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DomainNameConfig(
    domainName: Optional[DomainName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    appsyncDomainName: Optional[String] = Optional.Absent,
    hostedZoneId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DomainNameConfig = {
    import DomainNameConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DomainNameConfig
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(appsyncDomainName.map(value => value: java.lang.String))(
        _.appsyncDomainName
      )
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DomainNameConfig.ReadOnly =
    zio.aws.appsync.model.DomainNameConfig.wrap(buildAwsValue())
}
object DomainNameConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DomainNameConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DomainNameConfig =
      zio.aws.appsync.model.DomainNameConfig(
        domainName.map(value => value),
        description.map(value => value),
        certificateArn.map(value => value),
        appsyncDomainName.map(value => value),
        hostedZoneId.map(value => value)
      )
    def domainName: Optional[DomainName]
    def description: Optional[Description]
    def certificateArn: Optional[CertificateArn]
    def appsyncDomainName: Optional[String]
    def hostedZoneId: Optional[String]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getAppsyncDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("appsyncDomainName", appsyncDomainName)
    def getHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DomainNameConfig
  ) extends zio.aws.appsync.model.DomainNameConfig.ReadOnly {
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.appsync.model.primitives.DomainName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appsync.model.primitives.Description(value))
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.appsync.model.primitives.CertificateArn(value))
    override val appsyncDomainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.appsyncDomainName())
      .map(value => value: String)
    override val hostedZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DomainNameConfig
  ): zio.aws.appsync.model.DomainNameConfig.ReadOnly = new Wrapper(impl)
}
