package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateFunctionResponse(
    functionConfiguration: Option[zio.aws.appsync.model.FunctionConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse = {
    import UpdateFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse
      .builder()
      .optionallyWith(
        functionConfiguration.map(value => value.buildAwsValue())
      )(_.functionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly =
    zio.aws.appsync.model.UpdateFunctionResponse.wrap(buildAwsValue())
}
object UpdateFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateFunctionResponse =
      zio.aws.appsync.model.UpdateFunctionResponse(
        functionConfiguration.map(value => value.asEditable)
      )
    def functionConfiguration
        : Option[zio.aws.appsync.model.FunctionConfiguration.ReadOnly]
    def getFunctionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.FunctionConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("functionConfiguration", functionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse
  ) extends zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly {
    override val functionConfiguration
        : Option[zio.aws.appsync.model.FunctionConfiguration.ReadOnly] = scala
      .Option(impl.functionConfiguration())
      .map(value => zio.aws.appsync.model.FunctionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse
  ): zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly = new Wrapper(impl)
}
