package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpDataSourceConfig(
    endpoint: Option[String] = None,
    authorizationConfig: Option[zio.aws.appsync.model.AuthorizationConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig = {
    import HttpDataSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig
      .builder()
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(authorizationConfig.map(value => value.buildAwsValue()))(
        _.authorizationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly =
    zio.aws.appsync.model.HttpDataSourceConfig.wrap(buildAwsValue())
}
object HttpDataSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.HttpDataSourceConfig =
      zio.aws.appsync.model.HttpDataSourceConfig(
        endpoint.map(value => value),
        authorizationConfig.map(value => value.asEditable)
      )
    def endpoint: Option[String]
    def authorizationConfig
        : Option[zio.aws.appsync.model.AuthorizationConfig.ReadOnly]
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getAuthorizationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.AuthorizationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("authorizationConfig", authorizationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig
  ) extends zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly {
    override val endpoint: Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val authorizationConfig
        : Option[zio.aws.appsync.model.AuthorizationConfig.ReadOnly] = scala
      .Option(impl.authorizationConfig())
      .map(value => zio.aws.appsync.model.AuthorizationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig
  ): zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly = new Wrapper(impl)
}
