package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ApiAssociation(
    domainName: Option[DomainName] = None,
    apiId: Option[String] = None,
    associationStatus: Option[zio.aws.appsync.model.AssociationStatus] = None,
    deploymentDetail: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ApiAssociation = {
    import ApiAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ApiAssociation
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(apiId.map(value => value: java.lang.String))(_.apiId)
      .optionallyWith(associationStatus.map(value => value.unwrap))(
        _.associationStatus
      )
      .optionallyWith(deploymentDetail.map(value => value: java.lang.String))(
        _.deploymentDetail
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ApiAssociation.ReadOnly =
    zio.aws.appsync.model.ApiAssociation.wrap(buildAwsValue())
}
object ApiAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ApiAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ApiAssociation =
      zio.aws.appsync.model.ApiAssociation(
        domainName.map(value => value),
        apiId.map(value => value),
        associationStatus.map(value => value),
        deploymentDetail.map(value => value)
      )
    def domainName: Option[DomainName]
    def apiId: Option[String]
    def associationStatus: Option[zio.aws.appsync.model.AssociationStatus]
    def deploymentDetail: Option[String]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getAssociationStatus
        : ZIO[Any, AwsError, zio.aws.appsync.model.AssociationStatus] =
      AwsError.unwrapOptionField("associationStatus", associationStatus)
    def getDeploymentDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentDetail", deploymentDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ApiAssociation
  ) extends zio.aws.appsync.model.ApiAssociation.ReadOnly {
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.appsync.model.primitives.DomainName(value))
    override val apiId: Option[String] =
      scala.Option(impl.apiId()).map(value => value: String)
    override val associationStatus
        : Option[zio.aws.appsync.model.AssociationStatus] = scala
      .Option(impl.associationStatus())
      .map(value => zio.aws.appsync.model.AssociationStatus.wrap(value))
    override val deploymentDetail: Option[String] =
      scala.Option(impl.deploymentDetail()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ApiAssociation
  ): zio.aws.appsync.model.ApiAssociation.ReadOnly = new Wrapper(impl)
}
