package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateResolverResponse(
    resolver: Option[zio.aws.appsync.model.Resolver] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateResolverResponse = {
    import UpdateResolverResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateResolverResponse
      .builder()
      .optionallyWith(resolver.map(value => value.buildAwsValue()))(_.resolver)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateResolverResponse.ReadOnly =
    zio.aws.appsync.model.UpdateResolverResponse.wrap(buildAwsValue())
}
object UpdateResolverResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateResolverResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateResolverResponse =
      zio.aws.appsync.model
        .UpdateResolverResponse(resolver.map(value => value.asEditable))
    def resolver: Option[zio.aws.appsync.model.Resolver.ReadOnly]
    def getResolver
        : ZIO[Any, AwsError, zio.aws.appsync.model.Resolver.ReadOnly] =
      AwsError.unwrapOptionField("resolver", resolver)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateResolverResponse
  ) extends zio.aws.appsync.model.UpdateResolverResponse.ReadOnly {
    override val resolver: Option[zio.aws.appsync.model.Resolver.ReadOnly] =
      scala
        .Option(impl.resolver())
        .map(value => zio.aws.appsync.model.Resolver.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateResolverResponse
  ): zio.aws.appsync.model.UpdateResolverResponse.ReadOnly = new Wrapper(impl)
}
