package zio.aws.appsync.model
import java.lang.Integer
import zio.aws.appsync.model.primitives.TTL
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LambdaAuthorizerConfig(
    authorizerResultTtlInSeconds: Option[TTL] = None,
    authorizerUri: String,
    identityValidationExpression: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig = {
    import LambdaAuthorizerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig
      .builder()
      .optionallyWith(
        authorizerResultTtlInSeconds.map(value => TTL.unwrap(value): Integer)
      )(_.authorizerResultTtlInSeconds)
      .authorizerUri(authorizerUri: java.lang.String)
      .optionallyWith(
        identityValidationExpression.map(value => value: java.lang.String)
      )(_.identityValidationExpression)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly =
    zio.aws.appsync.model.LambdaAuthorizerConfig.wrap(buildAwsValue())
}
object LambdaAuthorizerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.LambdaAuthorizerConfig =
      zio.aws.appsync.model.LambdaAuthorizerConfig(
        authorizerResultTtlInSeconds.map(value => value),
        authorizerUri,
        identityValidationExpression.map(value => value)
      )
    def authorizerResultTtlInSeconds: Option[TTL]
    def authorizerUri: String
    def identityValidationExpression: Option[String]
    def getAuthorizerResultTtlInSeconds: ZIO[Any, AwsError, TTL] =
      AwsError.unwrapOptionField(
        "authorizerResultTtlInSeconds",
        authorizerResultTtlInSeconds
      )
    def getAuthorizerUri: ZIO[Any, Nothing, String] = ZIO.succeed(authorizerUri)
    def getIdentityValidationExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "identityValidationExpression",
        identityValidationExpression
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig
  ) extends zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly {
    override val authorizerResultTtlInSeconds: Option[TTL] = scala
      .Option(impl.authorizerResultTtlInSeconds())
      .map(value => zio.aws.appsync.model.primitives.TTL(value))
    override val authorizerUri: String = impl.authorizerUri(): String
    override val identityValidationExpression: Option[String] = scala
      .Option(impl.identityValidationExpression())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig
  ): zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly = new Wrapper(impl)
}
