package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTypeRequest(
    apiId: String,
    typeName: ResourceName,
    format: zio.aws.appsync.model.TypeDefinitionFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetTypeRequest = {
    import GetTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetTypeRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .typeName(ResourceName.unwrap(typeName): java.lang.String)
      .format(format.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetTypeRequest.ReadOnly =
    zio.aws.appsync.model.GetTypeRequest.wrap(buildAwsValue())
}
object GetTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetTypeRequest =
      zio.aws.appsync.model.GetTypeRequest(apiId, typeName, format)
    def apiId: String
    def typeName: ResourceName
    def format: zio.aws.appsync.model.TypeDefinitionFormat
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getTypeName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(typeName)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.appsync.model.TypeDefinitionFormat] =
      ZIO.succeed(format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetTypeRequest
  ) extends zio.aws.appsync.model.GetTypeRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val typeName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.typeName())
    override val format: zio.aws.appsync.model.TypeDefinitionFormat =
      zio.aws.appsync.model.TypeDefinitionFormat.wrap(impl.format())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetTypeRequest
  ): zio.aws.appsync.model.GetTypeRequest.ReadOnly = new Wrapper(impl)
}
