package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDataSourceResponse(
    dataSource: Option[zio.aws.appsync.model.DataSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse = {
    import UpdateDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse
      .builder()
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateDataSourceResponse.ReadOnly =
    zio.aws.appsync.model.UpdateDataSourceResponse.wrap(buildAwsValue())
}
object UpdateDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateDataSourceResponse =
      zio.aws.appsync.model
        .UpdateDataSourceResponse(dataSource.map(value => value.asEditable))
    def dataSource: Option[zio.aws.appsync.model.DataSource.ReadOnly]
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.appsync.model.DataSource.ReadOnly] =
      AwsError.unwrapOptionField("dataSource", dataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse
  ) extends zio.aws.appsync.model.UpdateDataSourceResponse.ReadOnly {
    override val dataSource: Option[zio.aws.appsync.model.DataSource.ReadOnly] =
      scala
        .Option(impl.dataSource())
        .map(value => zio.aws.appsync.model.DataSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse
  ): zio.aws.appsync.model.UpdateDataSourceResponse.ReadOnly = new Wrapper(impl)
}
