package zio.aws.appsync.model
import scala.jdk.CollectionConverters.*
sealed trait OutputType {
  def unwrap: software.amazon.awssdk.services.appsync.model.OutputType
}
object OutputType {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.OutputType
  ): zio.aws.appsync.model.OutputType = value match {
    case software.amazon.awssdk.services.appsync.model.OutputType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.OutputType.SDL =>
      val r = SDL
      r
    case software.amazon.awssdk.services.appsync.model.OutputType.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.OutputType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.OutputType =
      software.amazon.awssdk.services.appsync.model.OutputType.UNKNOWN_TO_SDK_VERSION
  }
  case object SDL extends zio.aws.appsync.model.OutputType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.OutputType =
      software.amazon.awssdk.services.appsync.model.OutputType.SDL
  }
  case object JSON extends zio.aws.appsync.model.OutputType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.OutputType =
      software.amazon.awssdk.services.appsync.model.OutputType.JSON
  }
}
