package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OpenIDConnectConfig(
    issuer: String,
    clientId: Option[String] = None,
    iatTTL: Option[Long] = None,
    authTTL: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig = {
    import OpenIDConnectConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig
      .builder()
      .issuer(issuer: java.lang.String)
      .optionallyWith(clientId.map(value => value: java.lang.String))(
        _.clientId
      )
      .optionallyWith(iatTTL.map(value => value: java.lang.Long))(_.iatTTL)
      .optionallyWith(authTTL.map(value => value: java.lang.Long))(_.authTTL)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly =
    zio.aws.appsync.model.OpenIDConnectConfig.wrap(buildAwsValue())
}
object OpenIDConnectConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.OpenIDConnectConfig =
      zio.aws.appsync.model.OpenIDConnectConfig(
        issuer,
        clientId.map(value => value),
        iatTTL.map(value => value),
        authTTL.map(value => value)
      )
    def issuer: String
    def clientId: Option[String]
    def iatTTL: Option[Long]
    def authTTL: Option[Long]
    def getIssuer: ZIO[Any, Nothing, String] = ZIO.succeed(issuer)
    def getClientId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getIatTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("iatTTL", iatTTL)
    def getAuthTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("authTTL", authTTL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig
  ) extends zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly {
    override val issuer: String = impl.issuer(): String
    override val clientId: Option[String] =
      scala.Option(impl.clientId()).map(value => value: String)
    override val iatTTL: Option[Long] =
      scala.Option(impl.iatTTL()).map(value => value: Long)
    override val authTTL: Option[Long] =
      scala.Option(impl.authTTL()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig
  ): zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly = new Wrapper(impl)
}
