package zio.aws.appsync.model
import java.lang.Integer
import zio.aws.appsync.model.primitives.{
  MaxBatchSize,
  MappingTemplate,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Resolver(
    typeName: Option[ResourceName] = None,
    fieldName: Option[ResourceName] = None,
    dataSourceName: Option[ResourceName] = None,
    resolverArn: Option[String] = None,
    requestMappingTemplate: Option[MappingTemplate] = None,
    responseMappingTemplate: Option[MappingTemplate] = None,
    kind: Option[zio.aws.appsync.model.ResolverKind] = None,
    pipelineConfig: Option[zio.aws.appsync.model.PipelineConfig] = None,
    syncConfig: Option[zio.aws.appsync.model.SyncConfig] = None,
    cachingConfig: Option[zio.aws.appsync.model.CachingConfig] = None,
    maxBatchSize: Option[MaxBatchSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.Resolver = {
    import Resolver.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.Resolver
      .builder()
      .optionallyWith(
        typeName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        fieldName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.fieldName)
      .optionallyWith(
        dataSourceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.dataSourceName)
      .optionallyWith(resolverArn.map(value => value: java.lang.String))(
        _.resolverArn
      )
      .optionallyWith(
        requestMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.requestMappingTemplate)
      .optionallyWith(
        responseMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.responseMappingTemplate)
      .optionallyWith(kind.map(value => value.unwrap))(_.kind)
      .optionallyWith(pipelineConfig.map(value => value.buildAwsValue()))(
        _.pipelineConfig
      )
      .optionallyWith(syncConfig.map(value => value.buildAwsValue()))(
        _.syncConfig
      )
      .optionallyWith(cachingConfig.map(value => value.buildAwsValue()))(
        _.cachingConfig
      )
      .optionallyWith(
        maxBatchSize.map(value => MaxBatchSize.unwrap(value): Integer)
      )(_.maxBatchSize)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.Resolver.ReadOnly =
    zio.aws.appsync.model.Resolver.wrap(buildAwsValue())
}
object Resolver {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appsync.model.Resolver] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.Resolver =
      zio.aws.appsync.model.Resolver(
        typeName.map(value => value),
        fieldName.map(value => value),
        dataSourceName.map(value => value),
        resolverArn.map(value => value),
        requestMappingTemplate.map(value => value),
        responseMappingTemplate.map(value => value),
        kind.map(value => value),
        pipelineConfig.map(value => value.asEditable),
        syncConfig.map(value => value.asEditable),
        cachingConfig.map(value => value.asEditable),
        maxBatchSize.map(value => value)
      )
    def typeName: Option[ResourceName]
    def fieldName: Option[ResourceName]
    def dataSourceName: Option[ResourceName]
    def resolverArn: Option[String]
    def requestMappingTemplate: Option[MappingTemplate]
    def responseMappingTemplate: Option[MappingTemplate]
    def kind: Option[zio.aws.appsync.model.ResolverKind]
    def pipelineConfig: Option[zio.aws.appsync.model.PipelineConfig.ReadOnly]
    def syncConfig: Option[zio.aws.appsync.model.SyncConfig.ReadOnly]
    def cachingConfig: Option[zio.aws.appsync.model.CachingConfig.ReadOnly]
    def maxBatchSize: Option[MaxBatchSize]
    def getTypeName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getFieldName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("fieldName", fieldName)
    def getDataSourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("dataSourceName", dataSourceName)
    def getResolverArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resolverArn", resolverArn)
    def getRequestMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "requestMappingTemplate",
        requestMappingTemplate
      )
    def getResponseMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "responseMappingTemplate",
        responseMappingTemplate
      )
    def getKind: ZIO[Any, AwsError, zio.aws.appsync.model.ResolverKind] =
      AwsError.unwrapOptionField("kind", kind)
    def getPipelineConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.PipelineConfig.ReadOnly] =
      AwsError.unwrapOptionField("pipelineConfig", pipelineConfig)
    def getSyncConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.SyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("syncConfig", syncConfig)
    def getCachingConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.CachingConfig.ReadOnly] =
      AwsError.unwrapOptionField("cachingConfig", cachingConfig)
    def getMaxBatchSize: ZIO[Any, AwsError, MaxBatchSize] =
      AwsError.unwrapOptionField("maxBatchSize", maxBatchSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.Resolver
  ) extends zio.aws.appsync.model.Resolver.ReadOnly {
    override val typeName: Option[ResourceName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val fieldName: Option[ResourceName] = scala
      .Option(impl.fieldName())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val dataSourceName: Option[ResourceName] = scala
      .Option(impl.dataSourceName())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val resolverArn: Option[String] =
      scala.Option(impl.resolverArn()).map(value => value: String)
    override val requestMappingTemplate: Option[MappingTemplate] = scala
      .Option(impl.requestMappingTemplate())
      .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val responseMappingTemplate: Option[MappingTemplate] = scala
      .Option(impl.responseMappingTemplate())
      .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val kind: Option[zio.aws.appsync.model.ResolverKind] = scala
      .Option(impl.kind())
      .map(value => zio.aws.appsync.model.ResolverKind.wrap(value))
    override val pipelineConfig
        : Option[zio.aws.appsync.model.PipelineConfig.ReadOnly] = scala
      .Option(impl.pipelineConfig())
      .map(value => zio.aws.appsync.model.PipelineConfig.wrap(value))
    override val syncConfig: Option[zio.aws.appsync.model.SyncConfig.ReadOnly] =
      scala
        .Option(impl.syncConfig())
        .map(value => zio.aws.appsync.model.SyncConfig.wrap(value))
    override val cachingConfig
        : Option[zio.aws.appsync.model.CachingConfig.ReadOnly] = scala
      .Option(impl.cachingConfig())
      .map(value => zio.aws.appsync.model.CachingConfig.wrap(value))
    override val maxBatchSize: Option[MaxBatchSize] = scala
      .Option(impl.maxBatchSize())
      .map(value => zio.aws.appsync.model.primitives.MaxBatchSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.Resolver
  ): zio.aws.appsync.model.Resolver.ReadOnly = new Wrapper(impl)
}
