package zio.aws.appsync.model
import java.lang.Integer
import zio.aws.appsync.model.primitives.{
  MaxBatchSize,
  MappingTemplate,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateResolverRequest(
    apiId: String,
    typeName: ResourceName,
    fieldName: ResourceName,
    dataSourceName: Option[ResourceName] = None,
    requestMappingTemplate: Option[MappingTemplate] = None,
    responseMappingTemplate: Option[MappingTemplate] = None,
    kind: Option[zio.aws.appsync.model.ResolverKind] = None,
    pipelineConfig: Option[zio.aws.appsync.model.PipelineConfig] = None,
    syncConfig: Option[zio.aws.appsync.model.SyncConfig] = None,
    cachingConfig: Option[zio.aws.appsync.model.CachingConfig] = None,
    maxBatchSize: Option[MaxBatchSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateResolverRequest = {
    import UpdateResolverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateResolverRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .typeName(ResourceName.unwrap(typeName): java.lang.String)
      .fieldName(ResourceName.unwrap(fieldName): java.lang.String)
      .optionallyWith(
        dataSourceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.dataSourceName)
      .optionallyWith(
        requestMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.requestMappingTemplate)
      .optionallyWith(
        responseMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.responseMappingTemplate)
      .optionallyWith(kind.map(value => value.unwrap))(_.kind)
      .optionallyWith(pipelineConfig.map(value => value.buildAwsValue()))(
        _.pipelineConfig
      )
      .optionallyWith(syncConfig.map(value => value.buildAwsValue()))(
        _.syncConfig
      )
      .optionallyWith(cachingConfig.map(value => value.buildAwsValue()))(
        _.cachingConfig
      )
      .optionallyWith(
        maxBatchSize.map(value => MaxBatchSize.unwrap(value): Integer)
      )(_.maxBatchSize)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateResolverRequest.ReadOnly =
    zio.aws.appsync.model.UpdateResolverRequest.wrap(buildAwsValue())
}
object UpdateResolverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateResolverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateResolverRequest =
      zio.aws.appsync.model.UpdateResolverRequest(
        apiId,
        typeName,
        fieldName,
        dataSourceName.map(value => value),
        requestMappingTemplate.map(value => value),
        responseMappingTemplate.map(value => value),
        kind.map(value => value),
        pipelineConfig.map(value => value.asEditable),
        syncConfig.map(value => value.asEditable),
        cachingConfig.map(value => value.asEditable),
        maxBatchSize.map(value => value)
      )
    def apiId: String
    def typeName: ResourceName
    def fieldName: ResourceName
    def dataSourceName: Option[ResourceName]
    def requestMappingTemplate: Option[MappingTemplate]
    def responseMappingTemplate: Option[MappingTemplate]
    def kind: Option[zio.aws.appsync.model.ResolverKind]
    def pipelineConfig: Option[zio.aws.appsync.model.PipelineConfig.ReadOnly]
    def syncConfig: Option[zio.aws.appsync.model.SyncConfig.ReadOnly]
    def cachingConfig: Option[zio.aws.appsync.model.CachingConfig.ReadOnly]
    def maxBatchSize: Option[MaxBatchSize]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getTypeName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(typeName)
    def getFieldName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(fieldName)
    def getDataSourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("dataSourceName", dataSourceName)
    def getRequestMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "requestMappingTemplate",
        requestMappingTemplate
      )
    def getResponseMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "responseMappingTemplate",
        responseMappingTemplate
      )
    def getKind: ZIO[Any, AwsError, zio.aws.appsync.model.ResolverKind] =
      AwsError.unwrapOptionField("kind", kind)
    def getPipelineConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.PipelineConfig.ReadOnly] =
      AwsError.unwrapOptionField("pipelineConfig", pipelineConfig)
    def getSyncConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.SyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("syncConfig", syncConfig)
    def getCachingConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.CachingConfig.ReadOnly] =
      AwsError.unwrapOptionField("cachingConfig", cachingConfig)
    def getMaxBatchSize: ZIO[Any, AwsError, MaxBatchSize] =
      AwsError.unwrapOptionField("maxBatchSize", maxBatchSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateResolverRequest
  ) extends zio.aws.appsync.model.UpdateResolverRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val typeName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.typeName())
    override val fieldName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.fieldName())
    override val dataSourceName: Option[ResourceName] = scala
      .Option(impl.dataSourceName())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val requestMappingTemplate: Option[MappingTemplate] = scala
      .Option(impl.requestMappingTemplate())
      .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val responseMappingTemplate: Option[MappingTemplate] = scala
      .Option(impl.responseMappingTemplate())
      .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val kind: Option[zio.aws.appsync.model.ResolverKind] = scala
      .Option(impl.kind())
      .map(value => zio.aws.appsync.model.ResolverKind.wrap(value))
    override val pipelineConfig
        : Option[zio.aws.appsync.model.PipelineConfig.ReadOnly] = scala
      .Option(impl.pipelineConfig())
      .map(value => zio.aws.appsync.model.PipelineConfig.wrap(value))
    override val syncConfig: Option[zio.aws.appsync.model.SyncConfig.ReadOnly] =
      scala
        .Option(impl.syncConfig())
        .map(value => zio.aws.appsync.model.SyncConfig.wrap(value))
    override val cachingConfig
        : Option[zio.aws.appsync.model.CachingConfig.ReadOnly] = scala
      .Option(impl.cachingConfig())
      .map(value => zio.aws.appsync.model.CachingConfig.wrap(value))
    override val maxBatchSize: Option[MaxBatchSize] = scala
      .Option(impl.maxBatchSize())
      .map(value => zio.aws.appsync.model.primitives.MaxBatchSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateResolverRequest
  ): zio.aws.appsync.model.UpdateResolverRequest.ReadOnly = new Wrapper(impl)
}
