package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RdsHttpEndpointConfig(
    awsRegion: Option[String] = None,
    dbClusterIdentifier: Option[String] = None,
    databaseName: Option[String] = None,
    schema: Option[String] = None,
    awsSecretStoreArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.RdsHttpEndpointConfig = {
    import RdsHttpEndpointConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.RdsHttpEndpointConfig
      .builder()
      .optionallyWith(awsRegion.map(value => value: java.lang.String))(
        _.awsRegion
      )
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(schema.map(value => value: java.lang.String))(_.schema)
      .optionallyWith(awsSecretStoreArn.map(value => value: java.lang.String))(
        _.awsSecretStoreArn
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.RdsHttpEndpointConfig.ReadOnly =
    zio.aws.appsync.model.RdsHttpEndpointConfig.wrap(buildAwsValue())
}
object RdsHttpEndpointConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.RdsHttpEndpointConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.RdsHttpEndpointConfig =
      zio.aws.appsync.model.RdsHttpEndpointConfig(
        awsRegion.map(value => value),
        dbClusterIdentifier.map(value => value),
        databaseName.map(value => value),
        schema.map(value => value),
        awsSecretStoreArn.map(value => value)
      )
    def awsRegion: Option[String]
    def dbClusterIdentifier: Option[String]
    def databaseName: Option[String]
    def schema: Option[String]
    def awsSecretStoreArn: Option[String]
    def getAwsRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schema", schema)
    def getAwsSecretStoreArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsSecretStoreArn", awsSecretStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.RdsHttpEndpointConfig
  ) extends zio.aws.appsync.model.RdsHttpEndpointConfig.ReadOnly {
    override val awsRegion: Option[String] =
      scala.Option(impl.awsRegion()).map(value => value: String)
    override val dbClusterIdentifier: Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val schema: Option[String] =
      scala.Option(impl.schema()).map(value => value: String)
    override val awsSecretStoreArn: Option[String] =
      scala.Option(impl.awsSecretStoreArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.RdsHttpEndpointConfig
  ): zio.aws.appsync.model.RdsHttpEndpointConfig.ReadOnly = new Wrapper(impl)
}
