package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDomainNamesResponse(
    domainNameConfigs: Option[
      Iterable[zio.aws.appsync.model.DomainNameConfig]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse = {
    import ListDomainNamesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse
      .builder()
      .optionallyWith(
        domainNameConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainNameConfigs)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListDomainNamesResponse.ReadOnly =
    zio.aws.appsync.model.ListDomainNamesResponse.wrap(buildAwsValue())
}
object ListDomainNamesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListDomainNamesResponse =
      zio.aws.appsync.model.ListDomainNamesResponse(
        domainNameConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def domainNameConfigs
        : Option[List[zio.aws.appsync.model.DomainNameConfig.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getDomainNameConfigs: ZIO[Any, AwsError, List[
      zio.aws.appsync.model.DomainNameConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("domainNameConfigs", domainNameConfigs)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse
  ) extends zio.aws.appsync.model.ListDomainNamesResponse.ReadOnly {
    override val domainNameConfigs
        : Option[List[zio.aws.appsync.model.DomainNameConfig.ReadOnly]] = scala
      .Option(impl.domainNameConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.DomainNameConfig.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse
  ): zio.aws.appsync.model.ListDomainNamesResponse.ReadOnly = new Wrapper(impl)
}
