package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetFunctionResponse(
    functionConfiguration: Option[zio.aws.appsync.model.FunctionConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetFunctionResponse = {
    import GetFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetFunctionResponse
      .builder()
      .optionallyWith(
        functionConfiguration.map(value => value.buildAwsValue())
      )(_.functionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetFunctionResponse.ReadOnly =
    zio.aws.appsync.model.GetFunctionResponse.wrap(buildAwsValue())
}
object GetFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetFunctionResponse =
      zio.aws.appsync.model.GetFunctionResponse(
        functionConfiguration.map(value => value.asEditable)
      )
    def functionConfiguration
        : Option[zio.aws.appsync.model.FunctionConfiguration.ReadOnly]
    def getFunctionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.FunctionConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("functionConfiguration", functionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetFunctionResponse
  ) extends zio.aws.appsync.model.GetFunctionResponse.ReadOnly {
    override val functionConfiguration
        : Option[zio.aws.appsync.model.FunctionConfiguration.ReadOnly] = scala
      .Option(impl.functionConfiguration())
      .map(value => zio.aws.appsync.model.FunctionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetFunctionResponse
  ): zio.aws.appsync.model.GetFunctionResponse.ReadOnly = new Wrapper(impl)
}
