package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListResolversResponse(
    resolvers: Option[Iterable[zio.aws.appsync.model.Resolver]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListResolversResponse = {
    import ListResolversResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListResolversResponse
      .builder()
      .optionallyWith(
        resolvers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolvers)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListResolversResponse.ReadOnly =
    zio.aws.appsync.model.ListResolversResponse.wrap(buildAwsValue())
}
object ListResolversResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListResolversResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListResolversResponse =
      zio.aws.appsync.model.ListResolversResponse(
        resolvers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resolvers: Option[List[zio.aws.appsync.model.Resolver.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getResolvers
        : ZIO[Any, AwsError, List[zio.aws.appsync.model.Resolver.ReadOnly]] =
      AwsError.unwrapOptionField("resolvers", resolvers)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListResolversResponse
  ) extends zio.aws.appsync.model.ListResolversResponse.ReadOnly {
    override val resolvers
        : Option[List[zio.aws.appsync.model.Resolver.ReadOnly]] = scala
      .Option(impl.resolvers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.Resolver.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListResolversResponse
  ): zio.aws.appsync.model.ListResolversResponse.ReadOnly = new Wrapper(impl)
}
