package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{TagValue, TagKey, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GraphqlApi(
    name: Option[ResourceName] = None,
    apiId: Option[String] = None,
    authenticationType: Option[zio.aws.appsync.model.AuthenticationType] = None,
    logConfig: Option[zio.aws.appsync.model.LogConfig] = None,
    userPoolConfig: Option[zio.aws.appsync.model.UserPoolConfig] = None,
    openIDConnectConfig: Option[zio.aws.appsync.model.OpenIDConnectConfig] =
      None,
    arn: Option[String] = None,
    uris: Option[Map[String, String]] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    additionalAuthenticationProviders: Option[
      Iterable[zio.aws.appsync.model.AdditionalAuthenticationProvider]
    ] = None,
    xrayEnabled: Option[Boolean] = None,
    wafWebAclArn: Option[String] = None,
    lambdaAuthorizerConfig: Option[
      zio.aws.appsync.model.LambdaAuthorizerConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GraphqlApi = {
    import GraphqlApi.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GraphqlApi
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(apiId.map(value => value: java.lang.String))(_.apiId)
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(logConfig.map(value => value.buildAwsValue()))(
        _.logConfig
      )
      .optionallyWith(userPoolConfig.map(value => value.buildAwsValue()))(
        _.userPoolConfig
      )
      .optionallyWith(openIDConnectConfig.map(value => value.buildAwsValue()))(
        _.openIDConnectConfig
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        uris.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.uris)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAuthenticationProviders)
      .optionallyWith(xrayEnabled.map(value => value: java.lang.Boolean))(
        _.xrayEnabled
      )
      .optionallyWith(wafWebAclArn.map(value => value: java.lang.String))(
        _.wafWebAclArn
      )
      .optionallyWith(
        lambdaAuthorizerConfig.map(value => value.buildAwsValue())
      )(_.lambdaAuthorizerConfig)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GraphqlApi.ReadOnly =
    zio.aws.appsync.model.GraphqlApi.wrap(buildAwsValue())
}
object GraphqlApi {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GraphqlApi
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GraphqlApi =
      zio.aws.appsync.model.GraphqlApi(
        name.map(value => value),
        apiId.map(value => value),
        authenticationType.map(value => value),
        logConfig.map(value => value.asEditable),
        userPoolConfig.map(value => value.asEditable),
        openIDConnectConfig.map(value => value.asEditable),
        arn.map(value => value),
        uris.map(value => value),
        tags.map(value => value),
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        xrayEnabled.map(value => value),
        wafWebAclArn.map(value => value),
        lambdaAuthorizerConfig.map(value => value.asEditable)
      )
    def name: Option[ResourceName]
    def apiId: Option[String]
    def authenticationType: Option[zio.aws.appsync.model.AuthenticationType]
    def logConfig: Option[zio.aws.appsync.model.LogConfig.ReadOnly]
    def userPoolConfig: Option[zio.aws.appsync.model.UserPoolConfig.ReadOnly]
    def openIDConnectConfig
        : Option[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly]
    def arn: Option[String]
    def uris: Option[Map[String, String]]
    def tags: Option[Map[TagKey, TagValue]]
    def additionalAuthenticationProviders: Option[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ]
    def xrayEnabled: Option[Boolean]
    def wafWebAclArn: Option[String]
    def lambdaAuthorizerConfig
        : Option[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.appsync.model.AuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getLogConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.LogConfig.ReadOnly] =
      AwsError.unwrapOptionField("logConfig", logConfig)
    def getUserPoolConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.UserPoolConfig.ReadOnly] =
      AwsError.unwrapOptionField("userPoolConfig", userPoolConfig)
    def getOpenIDConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("openIDConnectConfig", openIDConnectConfig)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getUris: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("uris", uris)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAdditionalAuthenticationProviders: ZIO[Any, AwsError, List[
      zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalAuthenticationProviders",
      additionalAuthenticationProviders
    )
    def getXrayEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("xrayEnabled", xrayEnabled)
    def getWafWebAclArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("wafWebAclArn", wafWebAclArn)
    def getLambdaAuthorizerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaAuthorizerConfig",
      lambdaAuthorizerConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GraphqlApi
  ) extends zio.aws.appsync.model.GraphqlApi.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val apiId: Option[String] =
      scala.Option(impl.apiId()).map(value => value: String)
    override val authenticationType
        : Option[zio.aws.appsync.model.AuthenticationType] = scala
      .Option(impl.authenticationType())
      .map(value => zio.aws.appsync.model.AuthenticationType.wrap(value))
    override val logConfig: Option[zio.aws.appsync.model.LogConfig.ReadOnly] =
      scala
        .Option(impl.logConfig())
        .map(value => zio.aws.appsync.model.LogConfig.wrap(value))
    override val userPoolConfig
        : Option[zio.aws.appsync.model.UserPoolConfig.ReadOnly] = scala
      .Option(impl.userPoolConfig())
      .map(value => zio.aws.appsync.model.UserPoolConfig.wrap(value))
    override val openIDConnectConfig
        : Option[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly] = scala
      .Option(impl.openIDConnectConfig())
      .map(value => zio.aws.appsync.model.OpenIDConnectConfig.wrap(value))
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val uris: Option[Map[String, String]] = scala
      .Option(impl.uris())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appsync.model.primitives
              .TagKey(key) -> zio.aws.appsync.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val additionalAuthenticationProviders: Option[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ] = scala
      .Option(impl.additionalAuthenticationProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.AdditionalAuthenticationProvider.wrap(item)
        }.toList
      )
    override val xrayEnabled: Option[Boolean] =
      scala.Option(impl.xrayEnabled()).map(value => value: Boolean)
    override val wafWebAclArn: Option[String] =
      scala.Option(impl.wafWebAclArn()).map(value => value: String)
    override val lambdaAuthorizerConfig
        : Option[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly] = scala
      .Option(impl.lambdaAuthorizerConfig())
      .map(value => zio.aws.appsync.model.LambdaAuthorizerConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GraphqlApi
  ): zio.aws.appsync.model.GraphqlApi.ReadOnly = new Wrapper(impl)
}
