package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateResolverResponse(
    resolver: Option[zio.aws.appsync.model.Resolver] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateResolverResponse = {
    import CreateResolverResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateResolverResponse
      .builder()
      .optionallyWith(resolver.map(value => value.buildAwsValue()))(_.resolver)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateResolverResponse.ReadOnly =
    zio.aws.appsync.model.CreateResolverResponse.wrap(buildAwsValue())
}
object CreateResolverResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateResolverResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateResolverResponse =
      zio.aws.appsync.model
        .CreateResolverResponse(resolver.map(value => value.asEditable))
    def resolver: Option[zio.aws.appsync.model.Resolver.ReadOnly]
    def getResolver
        : ZIO[Any, AwsError, zio.aws.appsync.model.Resolver.ReadOnly] =
      AwsError.unwrapOptionField("resolver", resolver)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateResolverResponse
  ) extends zio.aws.appsync.model.CreateResolverResponse.ReadOnly {
    override val resolver: Option[zio.aws.appsync.model.Resolver.ReadOnly] =
      scala
        .Option(impl.resolver())
        .map(value => zio.aws.appsync.model.Resolver.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateResolverResponse
  ): zio.aws.appsync.model.CreateResolverResponse.ReadOnly = new Wrapper(impl)
}
