package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UserPoolConfig(
    userPoolId: String,
    awsRegion: String,
    defaultAction: zio.aws.appsync.model.DefaultAction,
    appIdClientRegex: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UserPoolConfig = {
    import UserPoolConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UserPoolConfig
      .builder()
      .userPoolId(userPoolId: java.lang.String)
      .awsRegion(awsRegion: java.lang.String)
      .defaultAction(defaultAction.unwrap)
      .optionallyWith(appIdClientRegex.map(value => value: java.lang.String))(
        _.appIdClientRegex
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UserPoolConfig.ReadOnly =
    zio.aws.appsync.model.UserPoolConfig.wrap(buildAwsValue())
}
object UserPoolConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UserPoolConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UserPoolConfig =
      zio.aws.appsync.model.UserPoolConfig(
        userPoolId,
        awsRegion,
        defaultAction,
        appIdClientRegex.map(value => value)
      )
    def userPoolId: String
    def awsRegion: String
    def defaultAction: zio.aws.appsync.model.DefaultAction
    def appIdClientRegex: Option[String]
    def getUserPoolId: ZIO[Any, Nothing, String] = ZIO.succeed(userPoolId)
    def getAwsRegion: ZIO[Any, Nothing, String] = ZIO.succeed(awsRegion)
    def getDefaultAction
        : ZIO[Any, Nothing, zio.aws.appsync.model.DefaultAction] =
      ZIO.succeed(defaultAction)
    def getAppIdClientRegex: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("appIdClientRegex", appIdClientRegex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UserPoolConfig
  ) extends zio.aws.appsync.model.UserPoolConfig.ReadOnly {
    override val userPoolId: String = impl.userPoolId(): String
    override val awsRegion: String = impl.awsRegion(): String
    override val defaultAction: zio.aws.appsync.model.DefaultAction =
      zio.aws.appsync.model.DefaultAction.wrap(impl.defaultAction())
    override val appIdClientRegex: Option[String] =
      scala.Option(impl.appIdClientRegex()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UserPoolConfig
  ): zio.aws.appsync.model.UserPoolConfig.ReadOnly = new Wrapper(impl)
}
