package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDataSourceResponse(
    dataSource: Option[zio.aws.appsync.model.DataSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse = {
    import CreateDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse
      .builder()
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateDataSourceResponse.ReadOnly =
    zio.aws.appsync.model.CreateDataSourceResponse.wrap(buildAwsValue())
}
object CreateDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateDataSourceResponse =
      zio.aws.appsync.model
        .CreateDataSourceResponse(dataSource.map(value => value.asEditable))
    def dataSource: Option[zio.aws.appsync.model.DataSource.ReadOnly]
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.appsync.model.DataSource.ReadOnly] =
      AwsError.unwrapOptionField("dataSource", dataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse
  ) extends zio.aws.appsync.model.CreateDataSourceResponse.ReadOnly {
    override val dataSource: Option[zio.aws.appsync.model.DataSource.ReadOnly] =
      scala
        .Option(impl.dataSource())
        .map(value => zio.aws.appsync.model.DataSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse
  ): zio.aws.appsync.model.CreateDataSourceResponse.ReadOnly = new Wrapper(impl)
}
