package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ApiCache(
    ttl: Option[Long] = None,
    apiCachingBehavior: Option[zio.aws.appsync.model.ApiCachingBehavior] = None,
    transitEncryptionEnabled: Option[Boolean] = None,
    atRestEncryptionEnabled: Option[Boolean] = None,
    `type`: Option[zio.aws.appsync.model.ApiCacheType] = None,
    status: Option[zio.aws.appsync.model.ApiCacheStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ApiCache = {
    import ApiCache.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ApiCache
      .builder()
      .optionallyWith(ttl.map(value => value: java.lang.Long))(_.ttl)
      .optionallyWith(apiCachingBehavior.map(value => value.unwrap))(
        _.apiCachingBehavior
      )
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ApiCache.ReadOnly =
    zio.aws.appsync.model.ApiCache.wrap(buildAwsValue())
}
object ApiCache {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appsync.model.ApiCache] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ApiCache =
      zio.aws.appsync.model.ApiCache(
        ttl.map(value => value),
        apiCachingBehavior.map(value => value),
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        `type`.map(value => value),
        status.map(value => value)
      )
    def ttl: Option[Long]
    def apiCachingBehavior: Option[zio.aws.appsync.model.ApiCachingBehavior]
    def transitEncryptionEnabled: Option[Boolean]
    def atRestEncryptionEnabled: Option[Boolean]
    def `type`: Option[zio.aws.appsync.model.ApiCacheType]
    def status: Option[zio.aws.appsync.model.ApiCacheStatus]
    def getTtl: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("ttl", ttl)
    def getApiCachingBehavior
        : ZIO[Any, AwsError, zio.aws.appsync.model.ApiCachingBehavior] =
      AwsError.unwrapOptionField("apiCachingBehavior", apiCachingBehavior)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("transitEncryptionEnabled", transitEncryptionEnabled)
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("atRestEncryptionEnabled", atRestEncryptionEnabled)
    def getType: ZIO[Any, AwsError, zio.aws.appsync.model.ApiCacheType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[Any, AwsError, zio.aws.appsync.model.ApiCacheStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ApiCache
  ) extends zio.aws.appsync.model.ApiCache.ReadOnly {
    override val ttl: Option[Long] =
      scala.Option(impl.ttl()).map(value => value: Long)
    override val apiCachingBehavior
        : Option[zio.aws.appsync.model.ApiCachingBehavior] = scala
      .Option(impl.apiCachingBehavior())
      .map(value => zio.aws.appsync.model.ApiCachingBehavior.wrap(value))
    override val transitEncryptionEnabled: Option[Boolean] =
      scala.Option(impl.transitEncryptionEnabled()).map(value => value: Boolean)
    override val atRestEncryptionEnabled: Option[Boolean] =
      scala.Option(impl.atRestEncryptionEnabled()).map(value => value: Boolean)
    override val `type`: Option[zio.aws.appsync.model.ApiCacheType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.appsync.model.ApiCacheType.wrap(value))
    override val status: Option[zio.aws.appsync.model.ApiCacheStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.appsync.model.ApiCacheStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ApiCache
  ): zio.aws.appsync.model.ApiCache.ReadOnly = new Wrapper(impl)
}
