package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateGraphqlApiRequest(
    apiId: String,
    name: String,
    logConfig: Option[zio.aws.appsync.model.LogConfig] = None,
    authenticationType: Option[zio.aws.appsync.model.AuthenticationType] = None,
    userPoolConfig: Option[zio.aws.appsync.model.UserPoolConfig] = None,
    openIDConnectConfig: Option[zio.aws.appsync.model.OpenIDConnectConfig] =
      None,
    additionalAuthenticationProviders: Option[
      Iterable[zio.aws.appsync.model.AdditionalAuthenticationProvider]
    ] = None,
    xrayEnabled: Option[Boolean] = None,
    lambdaAuthorizerConfig: Option[
      zio.aws.appsync.model.LambdaAuthorizerConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest = {
    import UpdateGraphqlApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(logConfig.map(value => value.buildAwsValue()))(
        _.logConfig
      )
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(userPoolConfig.map(value => value.buildAwsValue()))(
        _.userPoolConfig
      )
      .optionallyWith(openIDConnectConfig.map(value => value.buildAwsValue()))(
        _.openIDConnectConfig
      )
      .optionallyWith(
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAuthenticationProviders)
      .optionallyWith(xrayEnabled.map(value => value: java.lang.Boolean))(
        _.xrayEnabled
      )
      .optionallyWith(
        lambdaAuthorizerConfig.map(value => value.buildAwsValue())
      )(_.lambdaAuthorizerConfig)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateGraphqlApiRequest.ReadOnly =
    zio.aws.appsync.model.UpdateGraphqlApiRequest.wrap(buildAwsValue())
}
object UpdateGraphqlApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateGraphqlApiRequest =
      zio.aws.appsync.model.UpdateGraphqlApiRequest(
        apiId,
        name,
        logConfig.map(value => value.asEditable),
        authenticationType.map(value => value),
        userPoolConfig.map(value => value.asEditable),
        openIDConnectConfig.map(value => value.asEditable),
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        xrayEnabled.map(value => value),
        lambdaAuthorizerConfig.map(value => value.asEditable)
      )
    def apiId: String
    def name: String
    def logConfig: Option[zio.aws.appsync.model.LogConfig.ReadOnly]
    def authenticationType: Option[zio.aws.appsync.model.AuthenticationType]
    def userPoolConfig: Option[zio.aws.appsync.model.UserPoolConfig.ReadOnly]
    def openIDConnectConfig
        : Option[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly]
    def additionalAuthenticationProviders: Option[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ]
    def xrayEnabled: Option[Boolean]
    def lambdaAuthorizerConfig
        : Option[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getLogConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.LogConfig.ReadOnly] =
      AwsError.unwrapOptionField("logConfig", logConfig)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.appsync.model.AuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getUserPoolConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.UserPoolConfig.ReadOnly] =
      AwsError.unwrapOptionField("userPoolConfig", userPoolConfig)
    def getOpenIDConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("openIDConnectConfig", openIDConnectConfig)
    def getAdditionalAuthenticationProviders: ZIO[Any, AwsError, List[
      zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalAuthenticationProviders",
      additionalAuthenticationProviders
    )
    def getXrayEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("xrayEnabled", xrayEnabled)
    def getLambdaAuthorizerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaAuthorizerConfig",
      lambdaAuthorizerConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest
  ) extends zio.aws.appsync.model.UpdateGraphqlApiRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val name: String = impl.name(): String
    override val logConfig: Option[zio.aws.appsync.model.LogConfig.ReadOnly] =
      scala
        .Option(impl.logConfig())
        .map(value => zio.aws.appsync.model.LogConfig.wrap(value))
    override val authenticationType
        : Option[zio.aws.appsync.model.AuthenticationType] = scala
      .Option(impl.authenticationType())
      .map(value => zio.aws.appsync.model.AuthenticationType.wrap(value))
    override val userPoolConfig
        : Option[zio.aws.appsync.model.UserPoolConfig.ReadOnly] = scala
      .Option(impl.userPoolConfig())
      .map(value => zio.aws.appsync.model.UserPoolConfig.wrap(value))
    override val openIDConnectConfig
        : Option[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly] = scala
      .Option(impl.openIDConnectConfig())
      .map(value => zio.aws.appsync.model.OpenIDConnectConfig.wrap(value))
    override val additionalAuthenticationProviders: Option[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ] = scala
      .Option(impl.additionalAuthenticationProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.AdditionalAuthenticationProvider.wrap(item)
        }.toList
      )
    override val xrayEnabled: Option[Boolean] =
      scala.Option(impl.xrayEnabled()).map(value => value: Boolean)
    override val lambdaAuthorizerConfig
        : Option[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly] = scala
      .Option(impl.lambdaAuthorizerConfig())
      .map(value => zio.aws.appsync.model.LambdaAuthorizerConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest
  ): zio.aws.appsync.model.UpdateGraphqlApiRequest.ReadOnly = new Wrapper(impl)
}
