package zio.aws.appsync.model
import java.lang.Integer
import zio.aws.appsync.model.primitives.{MaxResults, PaginationToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListResolversRequest(
    apiId: String,
    typeName: String,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListResolversRequest = {
    import ListResolversRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListResolversRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .typeName(typeName: java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListResolversRequest.ReadOnly =
    zio.aws.appsync.model.ListResolversRequest.wrap(buildAwsValue())
}
object ListResolversRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListResolversRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListResolversRequest =
      zio.aws.appsync.model.ListResolversRequest(
        apiId,
        typeName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def apiId: String
    def typeName: String
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getTypeName: ZIO[Any, Nothing, String] = ZIO.succeed(typeName)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListResolversRequest
  ) extends zio.aws.appsync.model.ListResolversRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val typeName: String = impl.typeName(): String
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appsync.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListResolversRequest
  ): zio.aws.appsync.model.ListResolversRequest.ReadOnly = new Wrapper(impl)
}
