package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetApiCacheResponse(
    apiCache: Option[zio.aws.appsync.model.ApiCache] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetApiCacheResponse = {
    import GetApiCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetApiCacheResponse
      .builder()
      .optionallyWith(apiCache.map(value => value.buildAwsValue()))(_.apiCache)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetApiCacheResponse.ReadOnly =
    zio.aws.appsync.model.GetApiCacheResponse.wrap(buildAwsValue())
}
object GetApiCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetApiCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetApiCacheResponse =
      zio.aws.appsync.model
        .GetApiCacheResponse(apiCache.map(value => value.asEditable))
    def apiCache: Option[zio.aws.appsync.model.ApiCache.ReadOnly]
    def getApiCache
        : ZIO[Any, AwsError, zio.aws.appsync.model.ApiCache.ReadOnly] =
      AwsError.unwrapOptionField("apiCache", apiCache)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetApiCacheResponse
  ) extends zio.aws.appsync.model.GetApiCacheResponse.ReadOnly {
    override val apiCache: Option[zio.aws.appsync.model.ApiCache.ReadOnly] =
      scala
        .Option(impl.apiCache())
        .map(value => zio.aws.appsync.model.ApiCache.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetApiCacheResponse
  ): zio.aws.appsync.model.GetApiCacheResponse.ReadOnly = new Wrapper(impl)
}
