package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AwsIamConfig(
    signingRegion: Option[String] = None,
    signingServiceName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.AwsIamConfig = {
    import AwsIamConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.AwsIamConfig
      .builder()
      .optionallyWith(signingRegion.map(value => value: java.lang.String))(
        _.signingRegion
      )
      .optionallyWith(signingServiceName.map(value => value: java.lang.String))(
        _.signingServiceName
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.AwsIamConfig.ReadOnly =
    zio.aws.appsync.model.AwsIamConfig.wrap(buildAwsValue())
}
object AwsIamConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.AwsIamConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.AwsIamConfig =
      zio.aws.appsync.model.AwsIamConfig(
        signingRegion.map(value => value),
        signingServiceName.map(value => value)
      )
    def signingRegion: Option[String]
    def signingServiceName: Option[String]
    def getSigningRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signingRegion", signingRegion)
    def getSigningServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signingServiceName", signingServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.AwsIamConfig
  ) extends zio.aws.appsync.model.AwsIamConfig.ReadOnly {
    override val signingRegion: Option[String] =
      scala.Option(impl.signingRegion()).map(value => value: String)
    override val signingServiceName: Option[String] =
      scala.Option(impl.signingServiceName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.AwsIamConfig
  ): zio.aws.appsync.model.AwsIamConfig.ReadOnly = new Wrapper(impl)
}
