package zio.aws.appsync.model
import scala.jdk.CollectionConverters.*
sealed trait ResolverKind {
  def unwrap: software.amazon.awssdk.services.appsync.model.ResolverKind
}
object ResolverKind {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.ResolverKind
  ): zio.aws.appsync.model.ResolverKind = value match {
    case software.amazon.awssdk.services.appsync.model.ResolverKind.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.ResolverKind.UNIT =>
      val r = UNIT
      r
    case software.amazon.awssdk.services.appsync.model.ResolverKind.PIPELINE =>
      val r = PIPELINE
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.ResolverKind {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ResolverKind =
      software.amazon.awssdk.services.appsync.model.ResolverKind.UNKNOWN_TO_SDK_VERSION
  }
  case object UNIT extends zio.aws.appsync.model.ResolverKind {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ResolverKind =
      software.amazon.awssdk.services.appsync.model.ResolverKind.UNIT
  }
  case object PIPELINE extends zio.aws.appsync.model.ResolverKind {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ResolverKind =
      software.amazon.awssdk.services.appsync.model.ResolverKind.PIPELINE
  }
}
